//  
//  configVars.cs
//  
//  Author:
//       Robert BRACCAGNI alias Gai-Luron <lfsgailuron@free.fr>
// 
//  Copyright (c) 2010 Gai-Luron
// 
//  This program is free software: you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation, either version 3 of the License, or
//  (at your option) any later version.
// 
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
// 
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.


using System;
using Configurator;
using System.Reflection;
using UTILS;

namespace LFSLapper
{


    partial class LFSClient
    {
        public void getConfigVar(GLScript.unionVal val, string idVar )
        {
            Type TvarsLapper = newCfg.varsLapper.GetType();
            FieldInfo FIvarsLapper;



            FIvarsLapper = TvarsLapper.GetField(idVar);

            if (FIvarsLapper == null)
            {
                val.typVal = GLScript.typVal.str;
                val.sval = utils.quote( idVar + "=( not Found)");
                myDebug.WriteLine("err", "Warning config var : \"" + idVar + "\" doesn't exist!");
                return;
            }

            string typVarsLapper = FIvarsLapper.FieldType.Name;

            #region configvar
            switch (typVarsLapper)
            {
                case "String":
                    val.typVal = GLScript.typVal.str;
                    val.sval = utils.quote(FIvarsLapper.GetValue(newCfg.varsLapper).ToString());
                    return;
                case "Int32":
                case "Double":
                    val.typVal = GLScript.typVal.num;
                    val.fval = float.Parse( FIvarsLapper.GetValue(newCfg.varsLapper).ToString() );
                    return;
                case "Boolean":
                    val.typVal = GLScript.typVal.num;
                    if (bool.Parse(FIvarsLapper.GetValue(newCfg.varsLapper).ToString()))
                        val.fval = 1;
                    else
                        val.fval = 0;
                    return;
                default:
                    val.typVal = GLScript.typVal.str;
                    val.sval = utils.quote("");
                    return;
            }
            #endregion
        }
        public void setConfigVar(GLScript.unionVal val, string idVar,string strVal )
        {
            Type TvarsLapper = newCfg.varsLapper.GetType();
            FieldInfo FIvarsLapper;

            FIvarsLapper = TvarsLapper.GetField(idVar);

            if (FIvarsLapper == null)
            {
                val.typVal = GLScript.typVal.str;
                val.sval = utils.quote("");
                myDebug.WriteLine("err", "Warning config var: \"" + idVar + "\" doesn't exist!");
                return;
            }
            if (!Enum.IsDefined(typeof(configVarReadWrite), idVar.ToLower()))
            {
                val.typVal = GLScript.typVal.str;
                val.sval = utils.quote("");
                myDebug.WriteLine("err", "Warning config var: \"" + idVar + "\" is readonly!");
                return;
            }
            string typVarsLapper = FIvarsLapper.FieldType.Name;

            switch( typVarsLapper ){
                case "String":
                    FIvarsLapper.SetValue(newCfg.varsLapper, strVal);
                    break;
                case "Int32":
                    try
                    {
                        FIvarsLapper.SetValue(newCfg.varsLapper, int.Parse(strVal));
                    }
                    catch
                    {
                        myDebug.WriteLine("err","Var $" + idVar + " is wrong type: Need Integer value" );
                    }
                    break;
                case "Double":
                    try
                    {
                        FIvarsLapper.SetValue(newCfg.varsLapper, double.Parse(strVal.Replace(".", System.Globalization.NumberFormatInfo.CurrentInfo.CurrencyDecimalSeparator)));
                    }
                    catch
                    {
                        myDebug.WriteLine("err","Var $" + idVar + " is wrong type: Need float value" );
                    }
                    break;
                case "Boolean":
                    int boolVal = 0;
                    try
                    {
                        boolVal = int.Parse( strVal );
                    }
                    catch
                    {
                        myDebug.WriteLine("err","Var $" + idVar + " is wrong type: Need int value" );
                    }
                    if( boolVal != 0 )
                        FIvarsLapper.SetValue(newCfg.varsLapper, true);
                    else
                        FIvarsLapper.SetValue(newCfg.varsLapper, true);
                    break;

            }
            val.typVal = GLScript.typVal.str;
            val.sval = utils.quote("");
            return;

        }
    }

}
